
<?php $__env->startSection('panel'); ?>
    <div class="row mb-none-30">
        <div class="col-xl-3 col-lg-5 col-md-5 col-sm-12">
            <div class="card b-radius--10 overflow-hidden box--shadow1">
                <div class="card-body">
                    <h5 class="mb-20 text-muted"><?php echo app('translator')->get('Sender Staff'); ?></h5>
                    <ul class="list-group">
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <?php echo app('translator')->get('Fullname'); ?>
                            <span class="font-weight-bold"><?php echo e(__($courierInfo->senderStaff->fullname)); ?></span>
                        </li>

                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <?php echo app('translator')->get('Email'); ?>
                            <span class="font-weight-bold"><?php echo e(__($courierInfo->senderStaff->email)); ?></span>
                        </li>

                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <?php echo app('translator')->get('Branch'); ?>
                            <span class="font-weight-bold"><?php echo e(__($courierInfo->senderBranch->name)); ?></span>
                        </li>

                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <?php echo app('translator')->get('Status'); ?>
                            <?php if($courierInfo->senderStaff->status == 1): ?>
                                <span class="badge badge-pill bg--success"><?php echo app('translator')->get('Active'); ?></span>
                            <?php elseif($courierInfo->senderStaff->status == 0): ?>
                                <span class="badge badge-pill bg--danger"><?php echo app('translator')->get('Banned'); ?></span>
                            <?php endif; ?>
                        </li>
                    </ul>
                </div>
            </div>

            <?php if($courierInfo->receiver_staff_id): ?>
                <div class="card b-radius--10 overflow-hidden mt-30 box--shadow1">
                    <div class="card-body">
                        <h5 class="mb-20 text-muted"><?php echo app('translator')->get('Receiver Staff'); ?></h5>
                        <ul class="list-group">
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo app('translator')->get('Fullname'); ?>
                                <span class="font-weight-bold"><?php echo e(__($courierInfo->receiverStaff->fullname)); ?></span>
                            </li>

                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo app('translator')->get('Email'); ?>
                                <span class="font-weight-bold"><?php echo e(__($courierInfo->receiverStaff->email)); ?></span>
                            </li>

                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo app('translator')->get('Branch'); ?>
                                <span class="font-weight-bold"><?php echo e(__($courierInfo->receiverBranch->name)); ?></span>
                            </li>

                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo app('translator')->get('Status'); ?>
                                <?php if($courierInfo->receiverStaff->status == 1): ?>
                                    <span class="badge badge-pill bg--success"><?php echo app('translator')->get('Active'); ?></span>
                                <?php elseif($courierInfo->receiverStaff->status == 0): ?>
                                    <span class="badge badge-pill bg--danger"><?php echo app('translator')->get('Banned'); ?></span>
                                <?php endif; ?>
                            </li>
                        </ul>
                    </div>
                </div>
            <?php endif; ?>
        </div>

        <div class="col-xl-9 col-lg-7 col-md-7 col-sm-12 mt-10">
            <div class="row mb-30">
                <div class="col-lg-6 mt-2">
                    <div class="card border--dark">
                        <h5 class="card-header bg--dark"><?php echo app('translator')->get('Sender Information'); ?></h5>
                        <div class="card-body">
                            <ul class="list-group">
                                <li class="list-group-item d-flex justify-content-between align-items-center font-weight-bold">
                                  <?php echo app('translator')->get('Name'); ?>
                                  <span><?php echo e(__($courierInfo->sender_name)); ?></span>
                                </li>
                            
                                <li class="list-group-item d-flex justify-content-between align-items-center font-weight-bold">
                                  <?php echo app('translator')->get('Email'); ?>
                                  <span><?php echo e(__($courierInfo->sender_email)); ?></span>
                                </li>

                                <li class="list-group-item d-flex justify-content-between align-items-center font-weight-bold">
                                  <?php echo app('translator')->get('Phone'); ?>
                                    <span><?php echo e(__($courierInfo->sender_phone)); ?></span>
                                </li>

                                <li class="list-group-item d-flex justify-content-between align-items-center font-weight-bold">
                                  <?php echo app('translator')->get('Address'); ?>
                                  <span><?php echo e(__($courierInfo->sender_address)); ?></span>
                                </li>

                                <li class="list-group-item d-flex justify-content-between align-items-center font-weight-bold">
                                  <?php echo app('translator')->get('Order Number'); ?>
                                  <span><?php echo e(__($courierInfo->code)); ?></span>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>

                <div class="col-lg-6 mt-2">
                    <div class="card border--dark">
                        <h5 class="card-header bg--dark"><?php echo app('translator')->get('Receiver Information'); ?></h5>
                        <div class="card-body">
                            <ul class="list-group">
                                <li class="list-group-item d-flex justify-content-between align-items-center font-weight-bold">
                                  <?php echo app('translator')->get('Name'); ?>
                                  <span><?php echo e(__($courierInfo->receiver_name)); ?></span>
                                </li>
                            
                                <li class="list-group-item d-flex justify-content-between align-items-center font-weight-bold">
                                  <?php echo app('translator')->get('Email'); ?>
                                  <span><?php echo e(__($courierInfo->receiver_email)); ?></span>
                                </li>

                                <li class="list-group-item d-flex justify-content-between align-items-center font-weight-bold">
                                  <?php echo app('translator')->get('Phone'); ?>
                                    <span><?php echo e(__($courierInfo->receiver_phone)); ?></span>
                                </li>

                                <li class="list-group-item d-flex justify-content-between align-items-center font-weight-bold">
                                  <?php echo app('translator')->get('Address'); ?>
                                  <span><?php echo e(__($courierInfo->receiver_address)); ?></span>
                                </li>

                                <li class="list-group-item d-flex justify-content-between align-items-center font-weight-bold">
                                  <?php echo app('translator')->get('Status'); ?>
                                    <?php if($courierInfo->status == 0): ?>
                                        <span class="badge badge--primary"><?php echo app('translator')->get('Received'); ?></span>
                                    <?php elseif($courierInfo->status == 1): ?>
                                        <span class="badge badge--success"><?php echo app('translator')->get('Delivery'); ?></span>
                                    <?php endif; ?>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row mb-30">
                <div class="col-lg-12">
                    <div class="card border--dark">
                        <h5 class="card-header bg--dark"><?php echo app('translator')->get('Courier Details'); ?></h5>
                        <div class="card-body">
                            <div class="table-responsive--md  table-responsive">
                                <table class="table table--light style--two">
                                    <thead>
                                        <tr>
                                            <th scope="col"><?php echo app('translator')->get('Courier Type'); ?></th>
                                            <th scope="col"><?php echo app('translator')->get('Quantity'); ?></th>
                                            <th scope="col"><?php echo app('translator')->get('Fee'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $courierInfo->courierDetail; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $courier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td data-label="<?php echo app('translator')->get('Courier Type'); ?>">
                                                <?php echo e($courier->type->name); ?>

                                            </td>
                                            <td data-label="<?php echo app('translator')->get('Quantity'); ?>"><?php echo e($courier->qty); ?></td>
                                            <td data-label="<?php echo app('translator')->get('Fee'); ?>"><?php echo e(getAmount($courier->fee)); ?> <?php echo e($general->cur_text); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row mb-30">
                <div class="col-lg-12 mt-2">
                    <div class="card border--dark">
                        <h5 class="card-header bg--dark"><?php echo app('translator')->get('Payment Information'); ?></h5>
                        <div class="card-body">
                            <ul class="list-group">
                                <li class="list-group-item d-flex justify-content-between align-items-center font-weight-bold">
                                  <?php echo app('translator')->get('Receiver Name'); ?>
                                    <?php if(!empty($courierInfo->paymentInfo->receiver_id)): ?>
                                        <span><?php echo e(__($courierInfo->paymentInfo->receiver->username)); ?></span>
                                    <?php else: ?>
                                        <span><?php echo app('translator')->get('N/A'); ?></span>
                                    <?php endif; ?>
                                </li>
                                <li class="list-group-item d-flex justify-content-between align-items-center font-weight-bold">
                                  <?php echo app('translator')->get('Receiver Branch'); ?>
                                    <?php if(!empty($courierInfo->paymentInfo->branch_id)): ?>
                                        <span><?php echo e(__($courierInfo->paymentInfo->brach->name)); ?></span>
                                    <?php else: ?>
                                        <span><?php echo app('translator')->get('N/A'); ?></span>
                                    <?php endif; ?>
                                </li>
                                <li class="list-group-item d-flex justify-content-between align-items-center font-weight-bold">
                                  <?php echo app('translator')->get('Payment Date'); ?>
                                    <?php if(!empty($courierInfo->paymentInfo->date)): ?>
                                        <span><?php echo e(showDateTime($courierInfo->paymentInfo->date, 'd M Y')); ?></span>
                                    <?php else: ?>
                                        <span><?php echo app('translator')->get('N/A'); ?></span>
                                    <?php endif; ?>
                                </li>

                                 <li class="list-group-item d-flex justify-content-between align-items-center font-weight-bold">
                                  <?php echo app('translator')->get('Amount'); ?>
                                  <span><?php echo e(getAmount($courierInfo->paymentInfo->amount)); ?> <?php echo e($general->cur_text); ?></span>
                                </li>

                                <li class="list-group-item d-flex justify-content-between align-items-center font-weight-bold">
                                  <?php echo app('translator')->get('Status'); ?>
                                    <?php if($courierInfo->paymentInfo->status == 1): ?>
                                        <span class="badge badge--success"><?php echo app('translator')->get('Paid'); ?></span>
                                    <?php else: ?>
                                        <span class="badge badge--danger"><?php echo app('translator')->get('Unpaid'); ?></span>
                                    <?php endif; ?>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
    <a href="<?php echo e(route('staff.courier.list')); ?>" class="btn btn-sm btn--primary box--shadow1 text--small"><i class="la la-fw la-backward"></i><?php echo app('translator')->get('Go Back'); ?></a>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('staff.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/highogyr/public_html/core/resources/views/staff/courier/details.blade.php ENDPATH**/ ?>